import { PropsWithChildren, ReactNode } from "react"

// eslint-disable-next-line @typescript-eslint/no-explicit-any
export type TODO = any

export type ComponentWithClassName<T = object> = T & {
  className?: string
}

export type ComponentWithClassNameAndChildren<T = object> = PropsWithChildren<ComponentWithClassName<T>>

interface ServerComponentInternal<
  TRouteParams extends object = object
> {
  params: TRouteParams
}

/**
 * Param property type to be used with React server components and Nextjs implementation. Exposes route params and query params.
 */
export type ServerComponentParams<
  TRouteParams extends object = object,
  TSearchParams extends Record<string, string | string[] | undefined> = Record<string, string | string[] | undefined>
> = ServerComponentInternal<TRouteParams> & {
  searchParams?: TSearchParams;
}

/**
 * Param property type to be used with Nextjs layout components. Exposes route/query params and layout children.
 */
export type ServerLayoutProps<
  TRouteParams extends object = object,
> = ServerComponentInternal<TRouteParams> & {
  children: ReactNode
}

/**
 * Nextjs specific error page props
  */
export type ClientErrorProps = {
  error: Error & { digest?: string }
  reset: () => void
}

type __FetchArguments = Parameters<typeof fetch>

export type FetchUrl = __FetchArguments["0"]
export type FetchInit = __FetchArguments["1"]

export type FetchProps = {
  url: FetchUrl,
  init?: FetchInit
}
